
//
// To jest przykadowy kod z podrozdziau 26.6.1 Kontrolowanie czasu ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <ctime>
#include <iostream>

using namespace std;

//------------------------------------------------------------------------------

void do_something()
{
	static int i = 0;
	++i;
}

//------------------------------------------------------------------------------

int main()
{
	int n = 10000000;           // Wywouje funkcj do_something() n razy.

	clock_t t1 = clock();
	if (t1 == clock_t(-1)) {    // clock_t(1) oznacza clock() nie zadziaaa
		cerr << "Przykro mi, nie ma zegara.\n";
		exit(1);
	}

	for (int i = 0; i<n; i++) do_something();    // ptla mierzenia czasu

	clock_t t2 = clock();
	if (t2 == clock_t(-1)) {
		cerr << "Przepenienie zegara.\n";
		exit(2);
	}
	cout << "Wykonanie funkcji do_something() " << n << " razy zajo "
		<< double(t2t1)/CLOCKS_PER_SEC << " sekund."
		<< " (precyzja pomiaru: "
		<< CLOCKS_PER_SEC << " sekundy)\n";
}

}

//------------------------------------------------------------------------------
